#ifndef _NETINFO_H
#define _NETINFO_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	struct Bandwidth
	{
		float uploadBPS;
		float downloadBPS;
	};

	struct NetInfoBasic
	{
		int connectionStatus;
		const char* ipAddress;
		int natType;
		int natStunStatus;
		int natMappedAddr;
	};
	
	PRX_EXPORT bool PrxNetInfoIsBusy();
	PRX_EXPORT bool PrxNetInfoGetLastError(ResultCode* result);

	PRX_EXPORT ErrorCode PrxNetInfoRequestBandwidth();
	PRX_EXPORT bool PrxNetInfoGetBandwidth(Bandwidth* bandwidth);

	PRX_EXPORT ErrorCode PrxNetInfoRequestInfo();
	PRX_EXPORT ErrorCode PrxNetInfoGetInfo(NetInfoBasic* info);
	PRX_EXPORT int PrxNetInfoGetDeviceType();

	class CachedNetInfo
	{
	private:
		SimpleLock m_Lock;
		bool m_Busy;
		ResultCode m_LastResult;
		Bandwidth m_Bandwidth;

		sce::Toolkit::NP::Utilities::Future<SceNpUtilBandwidthTestResult> m_FutureBandwidth;
		sce::Toolkit::NP::Utilities::Future< sce::Toolkit::NP::NetStateBasic > m_FutureNetStateBasic;

	public:
		CachedNetInfo();
		~CachedNetInfo() {};

		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

		ErrorCode RequestBandwidth();
		ErrorCode GetBandwidth(Bandwidth* bandwidth);
		ErrorCode RequestNetInfo();
		ErrorCode GetNetInfo(NetInfoBasic* info);
	};

	extern CachedNetInfo gNetInfo;
};

#endif // _NETINFO_H
